<?php
/*
 * Xibo - Digital Signage - http://www.xibo.org.uk
 * Copyright (C) 2006-2013 Daniel Garner
 *
 * This file is part of Xibo.
 *
 * Xibo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version. 
 *
 * Xibo is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Xibo.  If not, see <http://www.gnu.org/licenses/>.
 */
defined('XIBO') or die("Sorry, you are not allowed to directly access this page.<br /> Please press the back button in your browser.");

Class PDOConnect {

	private static $conn = NULL;

	private function __construct() {}

	public static function init() {
		if (!self::$conn) {
			
			global $dbhost;
			global $dbuser;
			global $dbpass;
			global $dbname;

			// Open the connection and set the error mode
			self::$conn = new PDO('mysql:host=' . $dbhost . ';dbname=' . $dbname . ';', $dbuser, $dbpass);
			self::$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

			self::$conn->query("SET NAMES 'utf8'");
		}

		return self::$conn;
	}
}