/*!
* TableSorter 2.4.6 - Client-side table sorting with ease!
* Minified using UglifyJS (http://jscompress.com/)
* Copyright (c) 2007 Christian Bach
*/
!function($){"use strict";$.extend({tablesorter:new function(){function log(a){if(typeof console!=="undefined"&&typeof console.log!=="undefined"){console.log(a)}else{alert(a)}}function benchmark(a,b){log(a+" ("+((new Date).getTime()-b.getTime())+"ms)")}function getElementText(a,b,c){if(!b){return""}var d=a.config,e=d.textExtraction,f="";if(e==="simple"){if(d.supportsTextContent){f=b.textContent}else{f=$(b).text()}}else{if(typeof e==="function"){f=e(b,a,c)}else if(typeof e==="object"&&e.hasOwnProperty(c)){f=e[c](b,a,c)}else{f=d.supportsTextContent?b.textContent:$(b).text()}}return $.trim(f)}function detectParserForColumn(a,b,c,d){var e,f=ts.parsers.length,g=false,h="",i=true;while(h===""&&i){c++;if(b[c]){g=b[c].cells[d];h=getElementText(a,g,d);if(a.config.debug){log("Checking if value was empty on row "+c+", column: "+d+": "+h)}}else{i=false}}for(e=1;e<f;e++){if(ts.parsers[e].is(h,a,g)){return ts.parsers[e]}}return ts.parsers[0]}function buildParserCache(a,b){var c=a.config,d=$(a.tBodies).filter(":not(."+c.cssInfoBlock+")"),e,f,g,h,i,j,k,l="";if(d.length===0){return}e=d[0].rows;if(e[0]){f=[];g=e[0].cells.length;for(h=0;h<g;h++){i=b.filter(':not([colspan])[data-column="'+h+'"]:last,[colspan="1"][data-column="'+h+'"]:last');j=c.headers[h];k=ts.getParserById(ts.getData(i,j,"sorter"));c.empties[h]=ts.getData(i,j,"empty")||c.emptyTo||(c.emptyToBottom?"bottom":"top");c.strings[h]=ts.getData(i,j,"string")||c.stringTo||"max";if(!k){k=detectParserForColumn(a,e,-1,h)}if(c.debug){l+="column:"+h+"; parser:"+k.id+"; string:"+c.strings[h]+"; empty: "+c.empties[h]+"\n"}f.push(k)}}if(c.debug){log(l)}return f}function buildCache(a){var b=a.tBodies,c=a.config,d,e,f=c.parsers,g,h,i,j,k,l,m;c.cache={};if(c.debug){m=new Date}if(c.showProcessing){ts.isProcessing(a,true)}for(j=0;j<b.length;j++){c.cache[j]={row:[],normalized:[]};if(!$(b[j]).hasClass(c.cssInfoBlock)){d=b[j]&&b[j].rows.length||0;e=b[j].rows[0]&&b[j].rows[0].cells.length||0;for(h=0;h<d;++h){k=$(b[j].rows[h]);l=[];if(k.hasClass(c.cssChildRow)){c.cache[j].row[c.cache[j].row.length-1]=c.cache[j].row[c.cache[j].row.length-1].add(k);continue}c.cache[j].row.push(k);for(i=0;i<e;++i){g=getElementText(a,k[0].cells[i],i);l.push(f[i].format(g,a,k[0].cells[i],i))}l.push(c.cache[j].normalized.length);c.cache[j].normalized.push(l)}}}if(c.showProcessing){ts.isProcessing(a)}if(c.debug){benchmark("Building cache for "+d+" rows",m)}}function appendToTable(a,b){var c=a.config,d=a.tBodies,e=[],f=c.cache,g,h,i,j,k,l,m,n,o,p,q,r;if(c.debug){r=new Date}for(o=0;o<d.length;o++){k=$(d[o]);if(!k.hasClass(c.cssInfoBlock)){l=ts.processTbody(a,k,true);g=f[o].row;h=f[o].normalized;i=h.length;j=i?h[0].length-1:0;for(m=0;m<i;m++){q=h[m][j];e.push(g[q]);if(!c.appender||!c.removeRows){p=g[q].length;for(n=0;n<p;n++){l.append(g[q][n])}}}ts.processTbody(a,l,false)}}if(c.appender){c.appender(a,e)}if(c.debug){benchmark("Rebuilt table",r)}if(!b){ts.applyWidget(a)}$(a).trigger("sortEnd",a)}function computeThIndexes(a){var b=[],c={},d=$(a).find("thead:eq(0) tr, tfoot tr"),e,f,g,h,i,j,k,l,m,n,o,p;for(e=0;e<d.length;e++){j=d[e].cells;for(f=0;f<j.length;f++){i=j[f];k=i.parentNode.rowIndex;l=k+"-"+i.cellIndex;m=i.rowSpan||1;n=i.colSpan||1;if(typeof b[k]==="undefined"){b[k]=[]}for(g=0;g<b[k].length+1;g++){if(typeof b[k][g]==="undefined"){o=g;break}}c[l]=o;$(i).attr({"data-column":o});for(g=k;g<k+m;g++){if(typeof b[g]==="undefined"){b[g]=[]}p=b[g];for(h=o;h<o+n;h++){p[h]="x"}}}}return c}function formatSortingOrder(a){return/^d/i.test(a)||a===1}function buildHeaders(a){var b=computeThIndexes(a),c,d,e,f,g,h,i=a.config;i.headerList=[];if(i.debug){g=new Date}h=$(a).find(i.selectorHeaders).each(function(a){d=$(this);c=i.headers[a];e=i.cssIcon?'<i class="'+i.cssIcon+'"></i>':"";this.innerHTML='<div class="tablesorter-header-inner">'+this.innerHTML+e+"</div>";if(i.onRenderHeader){i.onRenderHeader.apply(d,[a])}this.column=b[this.parentNode.rowIndex+"-"+this.cellIndex];this.order=formatSortingOrder(ts.getData(d,c,"sortInitialOrder")||i.sortInitialOrder)?[1,0,2]:[0,1,2];this.count=-1;if(ts.getData(d,c,"sorter")==="false"){this.sortDisabled=true;d.addClass("sorter-false")}else{d.removeClass("sorter-false")}this.lockedOrder=false;f=ts.getData(d,c,"lockedOrder")||false;if(typeof f!=="undefined"&&f!==false){this.order=this.lockedOrder=formatSortingOrder(f)?[1,1,1]:[0,0,0]}d.addClass(this.sortDisabled?"sorter-false":i.cssHeader);i.headerList[a]=this;d.parent().addClass(i.cssHeaderRow)});if(a.config.debug){benchmark("Built headers:",g);log(h)}return h}function setHeadersCss(a,b){var c,d,e,f,g=a.config,h=g.sortList,i=[g.cssDesc,g.cssAsc],j=$(a).find("tfoot tr").children().removeClass(i.join(" "));b.removeClass(i.join(" "));f=h.length;for(d=0;d<f;d++){if(h[d][1]!==2){c=b.not(".sorter-false").filter('[data-column="'+h[d][0]+'"]'+(f===1?":last":""));if(c.length){for(e=0;e<c.length;e++){if(!c[e].sortDisabled){c.eq(e).addClass(i[h[d][1]]);if(j.length){j.filter('[data-column="'+h[d][0]+'"]').eq(e).addClass(i[h[d][1]])}}}}}}}function fixColumnWidth(a){if(a.config.widthFixed&&$(a).find("colgroup").length===0){var b=$("<colgroup>"),c=$(a).width();$("tr:first td",a.tBodies[0]).each(function(){b.append($("<col>").css("width",parseInt($(this).width()/c*1e3,10)/10+"%"))});$(a).prepend(b)}}function updateHeaderSortCount(a,b){var c,d,e=a.config,f=e.headerList.length,g=b||e.sortList;e.sortList=[];$.each(g,function(a,b){c=[parseInt(b[0],10),parseInt(b[1],10)];d=e.headerList[c[0]];if(d){e.sortList.push(c);d.count=c[1]%(e.sortReset?3:2)}})}function getCachedSortType(a,b){return a&&a[b]?a[b].type||"":""}function multisort(table){var dynamicExp,sortWrapper,col,mx=0,dir=0,tc=table.config,sortList=tc.sortList,l=sortList.length,bl=table.tBodies.length,sortTime,i,j,k,c,cache,lc,s,e,order,orgOrderCol;if(tc.debug){sortTime=new Date}for(k=0;k<bl;k++){dynamicExp="sortWrapper = function(a,b) {";cache=tc.cache[k];lc=cache.normalized.length;for(i=0;i<l;i++){c=sortList[i][0];order=sortList[i][1];s=/n/i.test(getCachedSortType(tc.parsers,c))?"Numeric":"Text";s+=order===0?"":"Desc";e="e"+i;if(/Numeric/.test(s)&&tc.strings[c]){for(j=0;j<lc;j++){col=Math.abs(parseFloat(cache.normalized[j][c]));mx=Math.max(mx,isNaN(col)?0:col)}if(typeof tc.string[tc.strings[c]]==="boolean"){dir=(order===0?1:-1)*(tc.string[tc.strings[c]]?-1:1)}else{dir=tc.strings[c]?tc.string[tc.strings[c]]||0:0}}dynamicExp+="var "+e+" = $.tablesorter.sort"+s+"(table,a["+c+"],b["+c+"],"+c+","+mx+","+dir+"); ";dynamicExp+="if ("+e+") { return "+e+"; } ";dynamicExp+="else { "}orgOrderCol=cache.normalized&&cache.normalized[0]?cache.normalized[0].length-1:0;dynamicExp+="return a["+orgOrderCol+"]-b["+orgOrderCol+"];";for(i=0;i<l;i++){dynamicExp+="}; "}dynamicExp+="return 0; ";dynamicExp+="}; ";cache.normalized.sort(eval(dynamicExp))}if(tc.debug){benchmark("Sorting on "+sortList.toString()+" and dir "+order+" time",sortTime)}}function resortComplete(a,b){a.trigger("updateComplete");if(typeof b==="function"){b(a[0])}}function checkResort(a,b,c){if(b!==false){a.trigger("sorton",[a[0].config.sortList,function(){resortComplete(a,c)}])}else{resortComplete(a,c)}}var ts=this;ts.version="2.4.5";ts.parsers=[];ts.widgets=[];ts.defaults={theme:"default",widthFixed:false,showProcessing:false,cancelSelection:true,dateFormat:"mmddyyyy",sortMultiSortKey:"shiftKey",usNumberFormat:true,delayInit:false,headers:{},ignoreCase:true,sortForce:null,sortList:[],sortAppend:null,sortInitialOrder:"asc",sortLocaleCompare:false,sortReset:false,sortRestart:false,emptyTo:"bottom",stringTo:"max",textExtraction:"simple",textSorter:null,widgets:[],widgetOptions:{zebra:["even","odd"]},initWidgets:true,initialized:null,onRenderHeader:null,tableClass:"tablesorter",cssAsc:"tablesorter-headerSortUp",cssChildRow:"tablesorter-childRow",cssDesc:"tablesorter-headerSortDown",cssHeader:"tablesorter-header",cssHeaderRow:"tablesorter-headerRow",cssIcon:"tablesorter-icon",cssInfoBlock:"tablesorter-infoOnly",cssProcessing:"tablesorter-processing",selectorHeaders:"> thead th, > thead td",selectorSort:"th, td",selectorRemove:".remove-me",debug:false,headerList:[],empties:{},strings:{},parsers:[]};ts.benchmark=benchmark;ts.construct=function(a){return this.each(function(){if(!this.tHead||this.tBodies.length===0||this.hasInitialized===true){return}var b,c,d=$(this),e,f,g,h="",i,j,k,l,m=$.metadata;this.hasInitialized=false;this.config={};e=$.extend(true,this.config,ts.defaults,a);$.data(this,"tablesorter",e);if(e.debug){$.data(this,"startoveralltimer",new Date)}e.supportsTextContent=$("<span>x</span>")[0].textContent==="x";e.supportsDataObject=parseFloat($.fn.jquery)>=1.4;e.string={max:1,min:-1,"max+":1,"max-":-1,zero:0,none:0,"null":0,top:true,bottom:false};if(!/tablesorter\-/.test(d.attr("class"))){h=e.theme!==""?" tablesorter-"+e.theme:""}d.addClass(e.tableClass+h);b=buildHeaders(this);e.parsers=buildParserCache(this,b);if(!e.delayInit){buildCache(this)}b.find("*").andSelf().filter(e.selectorSort).unbind("mousedown.tablesorter mouseup.tablesorter").bind("mousedown.tablesorter mouseup.tablesorter",function(a,c){var m=this.tagName.match("TH|TD")?$(this):$(this).parents("th, td").filter(":last"),n=m[0];if((a.which||a.button)!==1){return false}if(a.type==="mousedown"){l=(new Date).getTime();return a.target.tagName==="INPUT"?"":!e.cancelSelection}if(c!==true&&(new Date).getTime()-l>250){return false}if(e.delayInit&&!e.cache){buildCache(d[0])}if(!n.sortDisabled){d.trigger("sortStart",d[0]);h=!a[e.sortMultiSortKey];n.count=(n.count+1)%(e.sortReset?3:2);if(e.sortRestart){f=n;b.each(function(){if(this!==f&&(h||!$(this).is("."+e.cssDesc+",."+e.cssAsc))){this.count=-1}})}f=n.column;if(h){e.sortList=[];if(e.sortForce!==null){i=e.sortForce;for(g=0;g<i.length;g++){if(i[g][0]!==f){e.sortList.push(i[g])}}}k=n.order[n.count];if(k<2){e.sortList.push([f,k]);if(n.colSpan>1){for(g=1;g<n.colSpan;g++){e.sortList.push([f+g,k])}}}}else{if(e.sortAppend&&e.sortList.length>1){if(ts.isValueInArray(e.sortAppend[0][0],e.sortList)){e.sortList.pop()}}if(ts.isValueInArray(f,e.sortList)){for(g=0;g<e.sortList.length;g++){j=e.sortList[g];k=e.headerList[j[0]];if(j[0]===f){j[1]=k.order[k.count];if(j[1]===2){e.sortList.splice(g,1);k.count=-1}}}}else{k=n.order[n.count];if(k<2){e.sortList.push([f,k]);if(n.colSpan>1){for(g=1;g<n.colSpan;g++){e.sortList.push([f+g,k])}}}}}if(e.sortAppend!==null){i=e.sortAppend;for(g=0;g<i.length;g++){if(i[g][0]!==f){e.sortList.push(i[g])}}}d.trigger("sortBegin",d[0]);setTimeout(function(){setHeadersCss(d[0],b);multisort(d[0]);appendToTable(d[0])},1)}});if(e.cancelSelection){b.each(function(){this.onselectstart=function(){return false}})}d.unbind("update updateCell addRows sorton appendCache applyWidgetId applyWidgets refreshWidgets destroy mouseup mouseleave").bind("update",function(a,c,f){$(e.selectorRemove,this).remove();e.parsers=buildParserCache(this,b);buildCache(this);checkResort(d,c,f)}).bind("updateCell",function(a,b,c,f){var g,h,i,j=this,k=$(this).find("tbody"),l=k.index($(b).parents("tbody").filter(":last")),m=$(b).parents("tr").filter(":last");if(k.length&&l>=0){h=k.eq(l).find("tr").index(m);i=b.cellIndex;g=j.config.cache[l].normalized[h].length-1;j.config.cache[l].row[j.config.cache[l].normalized[h][g]]=m;j.config.cache[l].normalized[h][i]=e.parsers[i].format(getElementText(j,b,i),j,b,i);checkResort(d,c,f)}}).bind("addRows",function(a,b,c,f){var h,i=b.filter("tr").length,j=[],k=b[0].cells.length,l=this,m=$(this).find("tbody").index(b.closest("tbody"));for(h=0;h<i;h++){for(g=0;g<k;g++){j[g]=e.parsers[g].format(getElementText(l,b[h].cells[g],g),l,b[h].cells[g],g)}j.push(e.cache[m].row.length);e.cache[m].row.push([b[h]]);e.cache[m].normalized.push(j);j=[]}checkResort(d,c,f)}).bind("sorton",function(a,c,d,e){$(this).trigger("sortStart",this);updateHeaderSortCount(this,c);setHeadersCss(this,b);multisort(this);appendToTable(this,e);if(typeof d==="function"){d(this)}}).bind("appendCache",function(a,b,c){appendToTable(this,c);if(typeof b==="function"){b(this)}}).bind("applyWidgetId",function(a,b){ts.getWidgetById(b).format(this,e,e.widgetOptions)}).bind("applyWidgets",function(a,b){ts.applyWidget(this,b)}).bind("refreshWidgets",function(a,b,c){ts.refreshWidgets(this,b,c)}).bind("destroy",function(a,b,c){ts.destroy(this,b,c)});if(e.supportsDataObject&&typeof d.data().sortlist!=="undefined"){e.sortList=d.data().sortlist}else if(m&&d.metadata()&&d.metadata().sortlist){e.sortList=d.metadata().sortlist}ts.applyWidget(this,true);if(e.sortList.length>0){d.trigger("sorton",[e.sortList,{},!e.initWidgets])}else if(e.initWidgets){ts.applyWidget(this)}fixColumnWidth(this);if(e.showProcessing){d.unbind("sortBegin sortEnd").bind("sortBegin sortEnd",function(a){ts.isProcessing(d[0],a.type==="sortBegin")})}this.hasInitialized=true;if(e.debug){ts.benchmark("Overall initialization time",$.data(this,"startoveralltimer"))}d.trigger("tablesorter-initialized",this);if(typeof e.initialized==="function"){e.initialized(this)}})};ts.isProcessing=function(a,b,c){var d=a.config,e=c||$(a).find("."+d.cssHeader);if(b){if(d.sortList.length>0){e=e.filter(function(){return this.sortDisabled?false:ts.isValueInArray(parseFloat($(this).attr("data-column")),d.sortList)})}e.addClass(d.cssProcessing)}else{e.removeClass(d.cssProcessing)}};ts.processTbody=function(a,b,c){var d,e;if(c){b.before('<span class="tablesorter-savemyplace"/>');e=$.fn.detach?b.detach():b.remove();return e}e=$(a).find("span.tablesorter-savemyplace");b.insertAfter(e);e.remove()};ts.clearTableBody=function(a){$(a.tBodies).filter(":not(."+a.config.cssInfoBlock+")").empty()};ts.destroy=function(a,b,c){var d=$(a),e=a.config,f=d.find("thead:first");a.hasInitialized=false;f.find("tr:not(."+e.cssHeaderRow+")").remove();f.find(".tablesorter-resizer").remove();ts.refreshWidgets(a,true,true);d.removeData("tablesorter").unbind("update updateCell addRows sorton appendCache applyWidgetId applyWidgets refreshWidgets destroy mouseup mouseleave").find("."+e.cssHeader).unbind("click mousedown mousemove mouseup").removeClass(e.cssHeader+" "+e.cssAsc+" "+e.cssDesc).find(".tablesorter-header-inner").each(function(){if(e.cssIcon!==""){$(this).find("."+e.cssIcon).remove()}$(this).replaceWith($(this).contents())});if(b!==false){d.removeClass(e.tableClass)}if(typeof c==="function"){c(a)}};ts.regex=[/(^-?[0-9]+(\.?[0-9]*)[df]?e?[0-9]?$|^0x[0-9a-f]+$|[0-9]+)/gi,/(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,/^0x[0-9a-f]+$/i];ts.sortText=function(a,b,c,d){if(b===c){return 0}var e=a.config,f=e.string[e.empties[d]||e.emptyTo],g=ts.regex,h,i,j,k,l,m,n,o;if(b===""&&f!==0){return typeof f==="boolean"?f?-1:1:-f||-1}if(c===""&&f!==0){return typeof f==="boolean"?f?1:-1:f||1}if(typeof e.textSorter==="function"){return e.textSorter(b,c,a,d)}h=b.replace(g[0],"\\0$1\\0").replace(/\\0$/,"").replace(/^\\0/,"").split("\\0");j=c.replace(g[0],"\\0$1\\0").replace(/\\0$/,"").replace(/^\\0/,"").split("\\0");i=parseInt(b.match(g[2]),16)||h.length!==1&&b.match(g[1])&&Date.parse(b);k=parseInt(c.match(g[2]),16)||i&&c.match(g[1])&&Date.parse(c)||null;if(k){if(i<k){return-1}if(i>k){return 1}}o=Math.max(h.length,j.length);for(n=0;n<o;n++){l=isNaN(h[n])?h[n]||0:parseFloat(h[n])||0;m=isNaN(j[n])?j[n]||0:parseFloat(j[n])||0;if(isNaN(l)!==isNaN(m)){return isNaN(l)?1:-1}if(typeof l!==typeof m){l+="";m+=""}if(l<m){return-1}if(l>m){return 1}}return 0};ts.sortTextDesc=function(a,b,c,d){if(b===c){return 0}var e=a.config,f=e.string[e.empties[d]||e.emptyTo];if(b===""&&f!==0){return typeof f==="boolean"?f?-1:1:f||1}if(c===""&&f!==0){return typeof f==="boolean"?f?1:-1:-f||-1}if(typeof e.textSorter==="function"){return e.textSorter(c,b,a,d)}return ts.sortText(a,c,b)};ts.getTextValue=function(a,b,c){if(b){var d,e=a.length,f=b+c;for(d=0;d<e;d++){f+=a.charCodeAt(d)}return c*f}return 0};ts.sortNumeric=function(a,b,c,d,e,f){if(b===c){return 0}var g=a.config,h=g.string[g.empties[d]||g.emptyTo];if(b===""&&h!==0){return typeof h==="boolean"?h?-1:1:-h||-1}if(c===""&&h!==0){return typeof h==="boolean"?h?1:-1:h||1}if(isNaN(b)){b=ts.getTextValue(b,e,f)}if(isNaN(c)){c=ts.getTextValue(c,e,f)}return b-c};ts.sortNumericDesc=function(a,b,c,d,e,f){if(b===c){return 0}var g=a.config,h=g.string[g.empties[d]||g.emptyTo];if(b===""&&h!==0){return typeof h==="boolean"?h?-1:1:h||1}if(c===""&&h!==0){return typeof h==="boolean"?h?1:-1:-h||-1}if(isNaN(b)){b=ts.getTextValue(b,e,f)}if(isNaN(c)){c=ts.getTextValue(c,e,f)}return c-b};ts.characterEquivalents={a:"\u00e1\u00e0\u00e2\u00e3\u00e4",A:"\u00c1\u00c0\u00c2\u00c3\u00c4",c:"\u00e7",C:"\u00c7",e:"\u00e9\u00e8\u00ea\u00eb",E:"\u00c9\u00c8\u00ca\u00cb",i:"\u00ed\u00ec\u0130\u00ee\u00ef",I:"\u00cd\u00cc\u0130\u00ce\u00cf",o:"\u00f3\u00f2\u00f4\u00f5\u00f6",O:"\u00d3\u00d2\u00d4\u00d5\u00d6",S:"\u00df",u:"\u00fa\u00f9\u00fb\u00fc",U:"\u00da\u00d9\u00db\u00dc"};;ts.replaceAccents=function(a){var b,c="[",d=ts.characterEquivalents;if(!ts.characterRegex){ts.characterRegexArray={};for(b in d){if(typeof b==="string"){c+=d[b];ts.characterRegexArray[b]=new RegExp("["+d[b]+"]","g")}}ts.characterRegex=new RegExp(c+"]")}if(ts.characterRegex.test(a)){for(b in d){if(typeof b==="string"){a=a.replace(ts.characterRegexArray[b],b)}}}return a};ts.isValueInArray=function(a,b){var c,d=b.length;for(c=0;c<d;c++){if(b[c][0]===a){return true}}return false};ts.addParser=function(a){var b,c=ts.parsers.length,d=true;for(b=0;b<c;b++){if(ts.parsers[b].id.toLowerCase()===a.id.toLowerCase()){d=false}}if(d){ts.parsers.push(a)}};ts.getParserById=function(a){var b,c=ts.parsers.length;for(b=0;b<c;b++){if(ts.parsers[b].id.toLowerCase()===a.toString().toLowerCase()){return ts.parsers[b]}}return false};ts.addWidget=function(a){ts.widgets.push(a)};ts.getWidgetById=function(a){var b,c,d=ts.widgets.length;for(b=0;b<d;b++){c=ts.widgets[b];if(c&&c.hasOwnProperty("id")&&c.id.toLowerCase()===a.toLowerCase()){return c}}};ts.applyWidget=function(a,b){var c=a.config,d=c.widgetOptions,e=c.widgets.sort().reverse(),f,g,h,i=e.length;g=$.inArray("zebra",c.widgets);if(g>=0){c.widgets.splice(g,1);c.widgets.push("zebra")}if(c.debug){f=new Date}for(g=0;g<i;g++){h=ts.getWidgetById(e[g]);if(h){if(b===true&&h.hasOwnProperty("init")){h.init(a,h,c,d)}else if(!b&&h.hasOwnProperty("format")){h.format(a,c,d)}}}if(c.debug){benchmark("Completed "+(b===true?"initializing":"applying")+" widgets",f)}};ts.refreshWidgets=function(a,b,c){var d,e=a.config,f=e.widgets,g=ts.widgets,h=g.length;for(d=0;d<h;d++){if(g[d]&&g[d].id&&(b||$.inArray(g[d].id,f)<0)){if(e.debug){log("removing "+g[d].id)}if(g[d].hasOwnProperty("remove")){g[d].remove(a,e,e.widgetOptions)}}}if(c!==true){ts.applyWidget(a,b)}};ts.getData=function(a,b,c){var d="",e=$(a),f,g;if(!e.length){return""}f=$.metadata?e.metadata():false;g=" "+(e.attr("class")||"");if(typeof e.data(c)!=="undefined"||typeof e.data(c.toLowerCase())!=="undefined"){d+=e.data(c)||e.data(c.toLowerCase())}else if(f&&typeof f[c]!=="undefined"){d+=f[c]}else if(b&&typeof b[c]!=="undefined"){d+=b[c]}else if(g!==" "&&g.match(" "+c+"-")){d=g.match(new RegExp(" "+c+"-(\\w+)"))[1]||""}return $.trim(d)};ts.formatFloat=function(a,b){if(typeof a!=="string"||a===""){return a}if(b.config.usNumberFormat!==false){a=a.replace(/,/g,"")}else{a=a.replace(/[\s|\.]/g,"").replace(/,/g,".")}if(/^\s*\([.\d]+\)/.test(a)){a=a.replace(/^\s*\(/,"-").replace(/\)/,"")}var c=parseFloat(a);return isNaN(c)?$.trim(a):c};ts.isDigit=function(a){return isNaN(a)?/^[\-+(]?\d+[)]?$/.test(a.toString().replace(/[,.'\s]/g,"")):true}}});var ts=$.tablesorter;$.fn.extend({tablesorter:ts.construct});ts.addParser({id:"text",is:function(a,b,c){return true},format:function(a,b,c,d){var e=b.config;a=$.trim(e.ignoreCase?a.toLocaleLowerCase():a);return e.sortLocaleCompare?ts.replaceAccents(a):a},type:"text"});ts.addParser({id:"currency",is:function(a){return/^\(?[\u00a3$\u20ac\u00a4\u00a5\u00a2?.]\d+/.test(a)},format:function(a,b){return ts.formatFloat(a.replace(/[^\w,. \-()]/g,""),b)},type:"numeric"});ts.addParser({id:"ipAddress",is:function(a){return/^\d{1,3}[\.]\d{1,3}[\.]\d{1,3}[\.]\d{1,3}$/.test(a)},format:function(a,b){var c,d=a.split("."),e="",f=d.length;for(c=0;c<f;c++){e+=("00"+d[c]).slice(-3)}return ts.formatFloat(e,b)},type:"numeric"});ts.addParser({id:"url",is:function(a){return/^(https?|ftp|file):\/\//.test(a)},format:function(a){return $.trim(a.replace(/(https?|ftp|file):\/\//,""))},type:"text"});ts.addParser({id:"isoDate",is:function(a){return/^\d{4}[\/\-]\d{1,2}[\/\-]\d{1,2}$/.test(a)},format:function(a,b){return ts.formatFloat(a!==""?(new Date(a.replace(/-/g,"/"))).getTime()||"":"",b)},type:"numeric"});ts.addParser({id:"percent",is:function(a){return/\d%\)?$/.test(a)},format:function(a,b){return ts.formatFloat(a.replace(/%/g,""),b)},type:"numeric"});ts.addParser({id:"usLongDate",is:function(a){return/^[A-Z]{3,10}\.?\s+\d{1,2},?\s+(\d{4}|'?\d{2})\s+(([0-2]?\d:[0-5]\d)|([0-1]?\d:[0-5]\d\s?([AP]M)))$/i.test(a)},format:function(a,b){return ts.formatFloat((new Date(a.replace(/(\S)([AP]M)$/i,"$1 $2"))).getTime()||"",b)},type:"numeric"});ts.addParser({id:"shortDate",is:function(a){return/^(\d{2}|\d{4})[\/\-\,\.\s+]\d{2}[\/\-\.\,\s+](\d{2}|\d{4})$/.test(a)},format:function(a,b,c,d){var e=b.config,f=e.headerList[d],g=f.shortDateFormat;if(typeof g==="undefined"){g=f.shortDateFormat=ts.getData(f,e.headers[d],"dateFormat")||e.dateFormat}a=a.replace(/\s+/g," ").replace(/[\-|\.|\,]/g,"/");if(g==="mmddyyyy"){a=a.replace(/(\d{1,2})[\/\s](\d{1,2})[\/\s](\d{4})/,"$3/$1/$2")}else if(g==="ddmmyyyy"){a=a.replace(/(\d{1,2})[\/\s](\d{1,2})[\/\s](\d{4})/,"$3/$2/$1")}else if(g==="yyyymmdd"){a=a.replace(/(\d{4})[\/\s](\d{1,2})[\/\s](\d{1,2})/,"$1/$2/$3")}return ts.formatFloat((new Date(a)).getTime()||"",b)},type:"numeric"});ts.addParser({id:"time",is:function(a){return/^(([0-2]?\d:[0-5]\d)|([0-1]?\d:[0-5]\d\s?([AP]M)))$/i.test(a)},format:function(a,b){return ts.formatFloat((new Date("2000/01/01 "+a.replace(/(\S)([AP]M)$/i,"$1 $2"))).getTime()||"",b)},type:"numeric"});ts.addParser({id:"digit",is:function(a){return ts.isDigit(a)},format:function(a,b){return ts.formatFloat(a.replace(/[^\w,. \-()]/g,""),b)},type:"numeric"});ts.addParser({id:"metadata",is:function(a){return false},format:function(a,b,c){var d=b.config,e=!d.parserMetadataName?"sortValue":d.parserMetadataName;return $(c).metadata()[e]},type:"numeric"});ts.addWidget({id:"zebra",format:function(a,b,c){var d,e,f,g,h,i,j,k,l=new RegExp(b.cssChildRow,"i"),m=$(a).children("tbody:not(."+b.cssInfoBlock+")");if(b.debug){i=new Date}for(j=0;j<m.length;j++){d=$(m[j]);k=d.children("tr").length;if(k>1){g=0;e=d.children("tr:visible");e.each(function(){f=$(this);if(!l.test(this.className)){g++}h=g%2===0;f.removeClass(c.zebra[h?1:0]).addClass(c.zebra[h?0:1])})}}if(b.debug){ts.benchmark("Applying Zebra widget",i)}},remove:function(a,b,c){var d,e,f=$(a).children("tbody:not(."+b.cssInfoBlock+")"),g=(b.widgetOptions.zebra||["even","odd"]).join(" ");for(d=0;d<f.length;d++){e=$.tablesorter.processTbody(a,$(f[d]),true);e.children().removeClass(g);$.tablesorter.processTbody(a,e,false)}}})}(jQuery)