<?php
/*
 * Xibo - Digital Signage - http://www.xibo.org.uk
 * Copyright (C) 2006-2013 Daniel Garner
 *
 * This file is part of Xibo.
 *
 * Xibo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version. 
 *
 * Xibo is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Xibo.  If not, see <http://www.gnu.org/licenses/>.
 */ 
defined('XIBO') or die("Sorry, you are not allowed to directly access this page.<br /> Please press the back button in your browser.");
?>
<h1 id="Counter">Counter</h1>

<p>The counter module provides an on screen counter which counts up or down in response to key presses (or to key presses generated by a wireless presenter style remote control - often used to control PowerPoint presentations).</p>

<p>It was originally written to cater for paper ticket systems where customers entering a business premises take a number from a dispenser and wait for their number to be called before obtaining a product or service.</p>

<p class="alert alert-danger">The Counter module is only supported by the Ubuntu Display Client</p>
	
<p>In its most basic form, there is no need to add a Counter media type at all. From v1.3.0 of the Ubuntu client, you can simply press Page Up or Page Down keys on the client machine (or via a wireless presenter style remote) and a pop-up overlay will appear displaying the current counter number.</p>

<p>This pop-up overlay can be styled and configured using the configuration variables in the client site.cfg file as follows:</p>

<ul>
	<li>nextScanCode=112 - Keyboard scan code used to increment the counter</li>
	<li>resetScanCode=0 - Keyboard scan code used to zero the counter</li>
	<li>prevScanCode=117 - Keyboard scan code used to decrement the counter</li>
	<li>maxCount=99 - Number the counter should count up to or down from</li>
	<li>osdBackColour=000000 - HTML/Hex colour for the pop-up background</li>
	<li>osdBackOpacity=0.7 - How opaque the background of the pop-up should be</li>
	<li>osdFontSize=270 - Font size of the number displayed in the pop-up</li>
	<li>osdFontColour=ffffff - Font colour of the number displayed in the pop-up in HTML/Hex</li>
	<li>osdWidthPercent=40 - Percentage of the width of the screen that the pop-up should occupy</li>
	<li>osdTimeOut=5000 - How many milliseconds the pop-up should be displayed for</li>
</ul>
	
<p>If you are not sure what scan codes there are, you can press "i" then "l" with the client running. That will pop-up the on-screen 
logging. Any key press that is not currently being used will generate a log message with the scan code for that key - so you 
can get the code you need and another the client configuration.</p>

<h2>The Counter Form</h2>
<p><img class="img-thumbnail" alt="Add Counter Form" src="content/layout/Ss_layout_designer_add_counter.png"></p></li>

<dl class="dl-horizontal">
	<dt>Duration</dt>
	<dd>The duration in seconds that this item should remain in the Region.</dd>
</dl>

<dl class="dl-horizontal">
	<dt>Pop-up Notification?</dt>
	<dd>Enables or disables the pop-up overlay. Leaving the box un-ticked will disable the pop-up while this media item is being shown on screen.</dd>
</dl>

<dl class="dl-horizontal">
	<dt>Template</dt>
	<dd>Editor for defining the template that should be used when displaying this Counter. The [Counter] tag should be used to indicate where the current Counter value should appear.</dd>
</dl>
