<?php
/*
 * Xibo - Digital Signage - http://www.xibo.org.uk
 * Copyright (C) 2006-2013 Daniel Garner
 *
 * This file is part of Xibo.
 *
 * Xibo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version. 
 *
 * Xibo is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Xibo.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Theme variables:
 *  form_id = The ID of the Form
 * 	form_action = The URL for calling the Layout Edit Transaction
 * 	form_meta = Additional META information required by Xibo in the form submit call
 */
defined('XIBO') or die("Sorry, you are not allowed to directly access this page.<br /> Please press the back button in your browser.");
?>
<div class="container-fluid">
	<form id="<?php echo Theme::Get('form_id'); ?>" class="XiboForm form-horizontal" method="post" action="<?php echo Theme::Get('form_action'); ?>">
		<?php echo Theme::Get('form_meta'); ?>
		<div class="row-fluid">
			<div class="control-group">
				<label class="control-label" for="dataset" accesskey="n" title="<?php echo Theme::Translate('A name for this DataSet'); ?>"><?php echo Theme::Translate('Name'); ?></label>
			    <div class="controls">
			        <input class="required" name="dataset" type="text" id="dataset" tabindex="1" maxlength="50" />
			    </div>
			</div>
			<div class="control-group">
				<label class="control-label" for="description" accesskey="n" title="<?php echo Theme::Translate('A description for this DataSet'); ?>"><?php echo Theme::Translate('Description'); ?></label>
			    <div class="controls">
			        <input class="" name="description" type="text" id="description" tabindex="1" maxlength="254" />
			    </div>
			</div>
		</div>
	</form>
</div>